; DDD modem 16c622
; AFSK 1200
;
;
; <c> Chris Boudacoff - 98
; mailto:lz1ddd@amsat.org
;
;
; The software may only be used noncommercially for amateur radio.
; Every other use, especially in other radio services,
; needs in every case the written consent of the author.
;
; The legal regulations concerning amateur radio are met.
;
; Commercial copying and selling without the written consent
; of the author is prohibited.


	processor	16C622
	INCLUDE	P16C622.INC

#DEFINE	_BANK	STATUS,RP0


TEMP	=	0x20
CMOLD	=	0x21
PGSTAT	=	0x22
#DEFINE	_VALID	PGSTAT,7
;#DEFINE	_DOWN	PGSTAT,6
#DEFINE	_INP	PORTB,0
#DEFINE	_PTTIN	PORTA,4

PLL	=	0x23
TOLOW	=	0x24
TOHIGH	=	0x25
CMTEMP	=	0x26
FASE	=	0x27

	ORG	0
	GOTO	START
	ORG	4
	BCF	_BANK
	BTFSC	PIR1,CMIF
	GOTO	DO_COMPA
	BTFSC	INTCON,T0IF
	GOTO	DO_TIMER
	MOVLW	0xF8
	ANDWF	INTCON,F
	RETFIE

DO_COMPA
	MOVFW	TMR0
	MOVWF	TEMP
	MOVLW	0x80
	MOVWF	TMR0

	BCF	INTCON,T0IF
	MOVFW	CMCON
	MOVWF	CMTEMP
	ANDLW	0x80
	XORWF	CMOLD,W
	BCF	PIR1,CMIF
	SKPNZ
	RETFIE
				; MODEM HERE
	BTFSC	_VALID
	BCF	PORTA,3		; TIME DECREASED 

	BSF	_VALID

	MOVFW	CMTEMP
	MOVWF	CMOLD

	RETFIE

DO_TIMER
	BCF	INTCON,T0IF
	BSF	PORTA,3		; IF OVER THEN 285uS THEN DATA HIGH
	BCF	_VALID
	RETFIE




SINUS
	ANDLW	0x7F
	ADDWF	PCL,F
;	include	sin256.asm	
; Auto generated for STEP=SAMPLE/256
              RETLW         0x0           ;0
              RETLW         0x2           ;1
              RETLW         0x3           ;2
              RETLW         0x5           ;3
              RETLW         0x6           ;4
              RETLW         0x8           ;5
              RETLW         0x9           ;6
              RETLW         0xB           ;7
              RETLW         0xC           ;8
              RETLW         0xE           ;9
              RETLW         0xF           ;A
              RETLW         0x11          ;B
              RETLW         0x12          ;C
              RETLW         0x14          ;D
              RETLW         0x15          ;E
              RETLW         0x17          ;F
              RETLW         0x18          ;10
              RETLW         0x1A          ;11
              RETLW         0x1B          ;12
              RETLW         0x1C          ;13
              RETLW         0x1E          ;14
              RETLW         0x1F          ;15
              RETLW         0x20          ;16
              RETLW         0x22          ;17
              RETLW         0x23          ;18
              RETLW         0x24          ;19
              RETLW         0x26          ;1A
              RETLW         0x27          ;1B
              RETLW         0x28          ;1C
              RETLW         0x29          ;1D
              RETLW         0x2A          ;1E
              RETLW         0x2B          ;1F
              RETLW         0x2D          ;20
              RETLW         0x2E          ;21
              RETLW         0x2F          ;22
              RETLW         0x30          ;23
              RETLW         0x31          ;24
              RETLW         0x32          ;25
              RETLW         0x33          ;26
              RETLW         0x34          ;27
              RETLW         0x34          ;28
              RETLW         0x35          ;29
              RETLW         0x36          ;2A
              RETLW         0x37          ;2B
              RETLW         0x38          ;2C
              RETLW         0x38          ;2D
              RETLW         0x39          ;2E
              RETLW         0x3A          ;2F
              RETLW         0x3A          ;30
              RETLW         0x3B          ;31
              RETLW         0x3B          ;32
              RETLW         0x3C          ;33
              RETLW         0x3C          ;34
              RETLW         0x3D          ;35
              RETLW         0x3D          ;36
              RETLW         0x3D          ;37
              RETLW         0x3E          ;38
              RETLW         0x3E          ;39
              RETLW         0x3E          ;3A
              RETLW         0x3F          ;3B
              RETLW         0x3F          ;3C
              RETLW         0x3F          ;3D
              RETLW         0x3F          ;3E
              RETLW         0x3F          ;3F
              RETLW         0x3F          ;40
              RETLW         0x3F          ;41
              RETLW         0x3F          ;42
              RETLW         0x3F          ;43
              RETLW         0x3F          ;44
              RETLW         0x3F          ;45
              RETLW         0x3E          ;46
              RETLW         0x3E          ;47
              RETLW         0x3E          ;48
              RETLW         0x3D          ;49
              RETLW         0x3D          ;4A
              RETLW         0x3D          ;4B
              RETLW         0x3C          ;4C
              RETLW         0x3C          ;4D
              RETLW         0x3B          ;4E
              RETLW         0x3B          ;4F
              RETLW         0x3A          ;50
              RETLW         0x3A          ;51
              RETLW         0x39          ;52
              RETLW         0x38          ;53
              RETLW         0x38          ;54
              RETLW         0x37          ;55
              RETLW         0x36          ;56
              RETLW         0x35          ;57
              RETLW         0x34          ;58
              RETLW         0x33          ;59
              RETLW         0x33          ;5A
              RETLW         0x32          ;5B
              RETLW         0x31          ;5C
              RETLW         0x30          ;5D
              RETLW         0x2F          ;5E
              RETLW         0x2E          ;5F
              RETLW         0x2D          ;60
              RETLW         0x2B          ;61
              RETLW         0x2A          ;62
              RETLW         0x29          ;63
              RETLW         0x28          ;64
              RETLW         0x27          ;65
              RETLW         0x25          ;66
              RETLW         0x24          ;67
              RETLW         0x23          ;68
              RETLW         0x22          ;69
              RETLW         0x20          ;6A
              RETLW         0x1F          ;6B
              RETLW         0x1E          ;6C
              RETLW         0x1C          ;6D
              RETLW         0x1B          ;6E
              RETLW         0x19          ;6F
              RETLW         0x18          ;70
              RETLW         0x17          ;71
              RETLW         0x15          ;72
              RETLW         0x14          ;73
              RETLW         0x12          ;74
              RETLW         0x11          ;75
              RETLW         0xF           ;76
              RETLW         0xE           ;77
              RETLW         0xC           ;78
              RETLW         0xB           ;79
              RETLW         0x9           ;7A
              RETLW         0x8           ;7B
              RETLW         0x6           ;7C
              RETLW         0x5           ;7D
              RETLW         0x3           ;7E
              RETLW         0x1           ;7F

START
	BCF	_BANK
	MOVLW	B'00000101'	; 
	MOVWF	CMCON

	MOVLW	B'01100000'
	MOVWF	INTCON		;T0IF, COMP IF



	BSF	_BANK
	MOVLW	B'00000000'	;VREF
	MOVWF	VRCON
	BSF	PIE1,CMIE	;EN COMP INT
	
	MOVLW	B'11000000'
	MOVWF	OPTION_REG

	MOVLW	B'11110111'
	MOVWF	TRISA

	MOVLW	B'00000001'
	MOVWF	TRISB

	MOVLW	0xC5
	MOVWF	VRCON
	BCF	_BANK
RECEIVE
	BCF	_BANK
	MOVLW	0x73		;2.25V AGND
	MOVWF	PORTB
	BSF	INTCON,GIE

LOOP
	CLRWDT
	BTFSC	_PTTIN
	GOTO	LOOP
TXING
	BCF	INTCON,GIE
TXLOOP
	BTFSC	TMR0,7
	GOTO	TXLOOP
	CLRWDT

	MOVLW	0xED
	MOVWF	TMR0
	MOVFW	FASE
	ADDLW	0x10		; 1200 Hz
	BTFSC	_INP
	ADDLW	0x0E		; 2250 Hz
	MOVWF	FASE
	CALL	SINUS
	BTFSS	FASE,7
	ADDLW	0x80
	BTFSC	FASE,7
	SUBLW	0x80
	MOVWF	PORTB
	BTFSS	_PTTIN
	GOTO	TXLOOP
	GOTO	RECEIVE




	ORG	0x2007
	DW	_PWRTE_ON & _WDT_ON & _XT_OSC

	END
